﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ProjectResourceList.aspx.cs" MasterPageFile="../Project.master" Inherits="GUI.CodeTables.ProjectResourceList" %>
<%@ Register Src="~/Controls/CodeTablesNavigation.ascx" TagName="CodeTablesNavigation" TagPrefix="uc" %>
<%@ Register Src="~/Controls/LanguageBox.ascx" TagName="LanguageBox" TagPrefix="uc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="FormPlaceHolder" runat="server">
    <div class="row">
        <div class="col-md-12 col-sm-12">
        <div class="portlet light bordered light-blue kendo-form">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, Codes_ProjectResources %>" /> </span>
                        <span class="caption-helper"></span>
                    </div>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-3 col-md-offset-9">
                                <uc:LanguageBox ID="LanguageBox" runat="server" Visible="true" />
                            </div>  
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">Id</label>
                                    <asp:TextBox CssClass="form-control" runat="server" ID="txtId" Enabled="False" />
                                </div>
                            </div>
                           
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label"> <asp:Literal ID="ltr1" runat="server" Text="<%$ Resources:ProjectManagementUI, Codes_ProjectResources %>" /></label>
                                     <asp:TextBox CssClass="form-control" runat="server" ValidationGroup="Validacija" ID="txtResource" />
                                    <span class="help-block">  <asp:RequiredFieldValidator ID="txtResourceRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic" CssClass="vError" SetFocusOnError="true"
														ControlToValidate="txtResource" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" 
														ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator> </span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                                                <div class="form-group">
                                        <label class="control-label "><asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Codes_ResourceType %>" /></label>
                                        <telerik:RadComboBox Skin="Bootstrap" Width="100%" runat="server" ValidationGroup="Validacija" ID="ddlResourceType" EmptyMessage="<%$ Resources:ProjectManagementUI, Common_Choose %>" RenderingMode="Full" />
                                        <span class="help-block"> <asp:RequiredFieldValidator ID="ddlResourceTypeRequired" ValidationGroup="Validacija" runat="server"  Display="Dynamic" SetFocusOnError="true" CssClass="vError"
														ControlToValidate="ddlResourceType" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" InitialValue=""
														ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span></div></div>
                            </div> 
                                            <div class="row">
                                                <div class="col-md-12">
                                                                                <div class="form-group">
                                    <label class="control-label"> <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Description %>" /></label>
                                     <asp:TextBox CssClass="form-control" Rows="5" Width="100%" TextMode="MultiLine" runat="server" ID="txtResourceDescription" />
                                   
                                </div>
                                                </div>
                                                </div>
                         <div class="form-actions right">
                              <asp:Button ID="btnSave" ValidationGroup="Validacija" OnClick="btnSave_Click" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                                    runat="server" />
                                <asp:Button ID="btnNew" OnClick="btnNew_Click" CssClass="btn blue " Text="<%$ Resources:ProjectManagementUI, Common_New %>" runat="server" />
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <telerik:RadGrid ID="grdProjectResources" runat="server" OnItemCommand="grdProjectResources_ItemCommand" Skin="Bootstrap">
					                <MasterTableView ShowHeadersWhenNoRecords="true" NoMasterRecordsText="<%$ Resources:ProjectManagementUI, Common_NoData %>" ShowFooter="False" AutoGenerateColumns="False"
						                AllowCustomSorting="false" DataKeyNames="Id">
						                <Columns>
							                <telerik:GridBoundColumn UniqueName="IdColumn" HeaderText="Id" DataField="Id" />
							                <telerik:GridBoundColumn UniqueName="ResourceNameColumn" SortExpression="ResourceName" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>"
								                DataField="ResourceName" />
                                            <telerik:GridBoundColumn UniqueName="ResourceTypeColumn" SortExpression="ResourceTypeId" HeaderText="<%$ Resources:ProjectManagementUI, Codes_ResourceType %>"
								                DataField="ResourceType.Name" />
							                <telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" HeaderStyle-Width="5%" ButtonCssClass="btn btn-sm blue" HeaderText="" ButtonType="LinkButton"
								                Text="<%$ Resources:ProjectManagementUI, Common_Edit %>" />
							                <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderStyle-Width="5%" ButtonCssClass="btn btn-sm red" HeaderText="" ButtonType="LinkButton"
								                Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ConfirmText="<%$ Resources:ProjectManagementUI, Common_DeletingConfirm %>" ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>"/>
						                </Columns>
					                </MasterTableView>
				                </telerik:RadGrid>
                            </div>
                        </div>
                       </div>
                    </div>
                </div>
            </div>
</div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:CodeTablesNavigation ID="CodeTablesNavigation" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="InfoPlaceHolder" runat="server"></asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="TitlePlaceHolder" runat="server"></asp:Content>